﻿using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Mvi.Mappers;
using VA.TMP.Integration.VIMT.Mvi.StateObject;
using VRM.Integration.Mvi.PersonSearch.Messages;
using VRM.Integration.Servicebus.Core;
using VA.TMP.OptionSets;

namespace VA.TMP.Integration.VIMT.Mvi.PipelineSteps.GetPersonIdentifiers
{
    /// <summary>
    /// Save Contact and Ids step.
    /// </summary>
    public class SaveContactAndIdsIntoCrmStep : FilterBase<GetPersonIdentifiersStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(GetPersonIdentifiersStateObject state)
        {
            var identifier = state.RawMviValue.Split('^').FirstOrDefault();

            if (string.IsNullOrEmpty(identifier))
            {
                Logger.Instance.Error("No RawMviValue in state object, unable to retrieve identifier");
            }
            else
            {
                using (var context = new Xrm(state.OrganizationServiceProxy))
                {
                    var contact = (from c in context.ContactSet
                                   join i in context.mcs_personidentifiersSet
                                   on c.Id equals i.mcs_patient.Id
                                   where
                                   i.mcs_identifier == identifier &&
                                   i.mcs_identifiertype.Value == (int)mcs_personidentifiersmcs_identifiertype.NationalIdentifier_NI &&
                                   i.mcs_assigningauthority == "USVHA"
                                   select c).FirstOrDefault();
                    if (contact == null)
                    {
                        state.Contact = MapGetPersonIdentifiersRequestToContact.Create(state.SelectedPersonRequest, state);
                        state.Contact.Id = state.OrganizationServiceProxy.Create(state.Contact);
                        state.Contact.ContactId = state.Contact.Id;
                    }
                    else
                    {
                        state.Contact = MapGetPersonIdentifiersRequestToContact.Update(state.SelectedPersonRequest, state, contact, state.OrganizationServiceProxy);
                        state.OrganizationServiceProxy.Update(state.Contact);
                    }
                }

                string lastfour;
                var ids = state.IsSearchNeeded 
                    ? MapGetPersonIdentifiersRequestToContact.GetPersonIdentifiers(state.CorrespondingIds, state.CorrespondingIdsResponse.Edipi, state.CorrespondingIdsResponse.SocialSecurityNumber ?? state.Ss, out lastfour) 
                    : MapGetPersonIdentifiersRequestToContact.GetPersonIdentifiers(state.CorrespondingIds, state.Edipi, string.Empty, out lastfour);
                MapGetPersonIdentifiersRequestToContact.GetUpdatedIdList(state.OrganizationServiceProxy, state.Contact.Id, ids);
            }
        }
    }
}